<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if shipping_id is provided in the GET request
if (isset($_GET['id'])) {
    // Sanitize and assign shipping_id
    $Id = intval($_GET['id']);

    // Initialize an array to hold the response data
    $response = [];

    // Fetch shipping method details
    $sql = "SELECT * FROM shippingmethod WHERE Delete_status = 0 AND shippingid = $Id";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $shippingMethod = [];
        while ($row = $result->fetch_assoc()) {
            $shippingMethod[] = $row;
        }
        $response['shipping_method'] = $shippingMethod;
    } else {
        // No shipping method found
        echo json_encode(['status' => 'error', 'message' => 'No shipping method found']);
        $conn->close();
        exit();
    }

    // Fetch shipping weight details
    $sql = "SELECT * FROM shipping_weight WHERE delete_status = 0 AND shipping_id = $Id";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $shippingWeight = [];
        while ($row = $result->fetch_assoc()) {
            $shippingWeight[] = $row;
        }
        $response['shipping_weight'] = $shippingWeight;
    } 

    // Return the combined response
    echo json_encode(['status' => 'success', 'data' => $response]);
} else {
    // shipping_id is not provided
    echo json_encode(['status' => 'error', 'message' => 'shipping_id is required']);
}

$conn->close();
?>